<?php

namespace backend\controllers;

use Yii;
use common\models\Groups;
use backend\models\GroupsSearch;
use backend\models\Admin;
use common\models\Files;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use \yii\web\Response;
use yii\helpers\Html;
use kartik\dialog\Dialog;

/**
 * GroupsController implements the CRUD actions for Groups model.
 */
class GroupsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                    'bulk-delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Groups models.
     * @return mixed
     */
    public function actionIndex()
    {   
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
 
        $searchModel = new GroupsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    /**
     * Displays a single Groups model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   
        $request = Yii::$app->request;
        if($request->isAjax){
            Yii::$app->response->format = Response::FORMAT_JSON;
            return [
                    'title'=> "Groups #".$id,
                    'content'=>$this->renderAjax('view', [
                        'model' => $this->findModel($id),
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                            Html::a('Edit',['update','id'=>$id],['class'=>'btn btn-primary','role'=>'modal-remote'])
                ];    
        }else{
            return $this->render('view', [
                'model' => $this->findModel($id),
            ]);
        }
    }

    /**
     * Creates a new Groups model.
     * For ajax request will return json object
     * and for non-ajax request if creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $request = Yii::$app->request;
        $model = new Groups();  

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            if($request->isGet){
                return [
                    'title'=> "Create new Groups",
                    'content'=>$this->renderAjax('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
        
                ];         
            }else if($model->load($request->post())){
                if($model->save()){
                    // generate links
                        
                    $model->l86 = '/issues/'.(string)(($model->id-1)*4+1);
                    $model->l64 = '/issues/'.(string)(($model->id-1)*4+2);
                    $model->b86 = '/issues/'.(string)(($model->id-1)*4+3);
                    $model->b64 = '/issues/'.(string)(($model->id-1)*4+4);

                    $model->save(false);

                    Yii::info('Admin '. Yii::$app->user->identity->login . ' creates group ' . $model->group, $category = 'admininfo');
                    
                    // QA create access
                    if(Yii::$app->user->identity->role == Admin::ROLE_MANAGER){
                        $a = Admin::findOne(['id'=>Yii::$app->user->identity->id]);
                        $a->groups = ($a->groups) ? $a->groups : '[]';
                        $adminGroups = json_decode($a->groups);
                        array_push($adminGroups, $model->group);
                        $a->groups = json_encode($adminGroups);
                        $a->save(false);
                    }
                    
                    return [
                        'forceReload'=>'#crud-datatable-pjax',
                        'title'=> "Create new Group",
                        'content'=>'<span class="text-success">Create New Group success</span>',
                        'footer'=> Html::button('Close',['class'=>'btn btn-default btn-orange pull-left','data-dismiss'=>"modal"])
            
                    ]; 
                }else{
                    return [
                        'title'=> "Update Group",
                        'content'=>$this->renderAjax('update', [
                            'model' => $model,
                        ]),
                        'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                    Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                    ];
                }        
            }else{           
                return [
                    'title'=> "Create new Groups",
                    'content'=>$this->renderAjax('create', [
                        'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
        
                ];         
            }
        }else{
            /*
            *   Process for non-ajax request
            */
            if ($model->load($request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }
       
    }

    /**
     * Updates an existing Groups model.
     * For ajax request will return json object
     * and for non-ajax request if update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    //public function actionUpdate($id)
    //{
        //$request = Yii::$app->request;
        //$model = $this->findModel($id);       

        //if($request->isAjax){
            /*
            *   Process for ajax request
            */
            //Yii::$app->response->format = Response::FORMAT_JSON;
            //if($request->isGet){
                //return [
                    //'title'=> "Update Groups #".$id,
                    //'content'=>$this->renderAjax('update', [
                        //'model' => $model,
                    //]),
                    //'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                                //Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                //];         
            //}else if($model->load($request->post()) && $model->save()){
                //return [
                    //'forceReload'=>'#crud-datatable-pjax',
                    //'title'=> "Groups #".$id,
                    //'content'=>$this->renderAjax('view', [
                        //'model' => $model,
                    //]),
                    //'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                            //Html::a('Edit',['update','id'=>$id],['class'=>'btn btn-primary','role'=>'modal-remote'])
                //];    
            //}else{
                 //return [
                    //'title'=> "Update Groups #".$id,
                    //'content'=>$this->renderAjax('update', [
                        //'model' => $model,
                    //]),
                    //'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"]).
                               /// Html::button('Save',['class'=>'btn btn-primary','type'=>"submit"])
                //];        
            //}
        //}else{
            /*
            *   Process for non-ajax request
            */
            //if ($model->load($request->post()) && $model->save()) {
                //return $this->redirect(['view', 'id' => $model->id]);
            //} else {
                //return $this->render('update', [
                    //'model' => $model,
                //]);
            //}
        //}
    //}

    /**
     * Delete an existing Groups model.
     * For ajax request will return json object
     * and for non-ajax request if deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    //public function actionDelete($id)
    //{
        //$request = Yii::$app->request;
        //$this->findModel($id)->delete();

        //if($request->isAjax){
            /*
            *   Process for ajax request
            */
            //Yii::$app->response->format = Response::FORMAT_JSON;
            //return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
        //}else{
            /*
            *   Process for non-ajax request
            */
            //return $this->redirect(['index']);
        //}


    //}


    /**
     * Finds the Groups model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Groups the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Groups::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }


    public function actionLoadertool($id)
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $request = Yii::$app->request;
        $model = $this->findModel($id);   
        $group = $model->group;
         
        if($request->isGet){ // render
            //$id = Bots::find()->where(['like', 'bot', $id])->one()['id']; // id as botid
            return $this->render('loadertool', [
                    'model' => $model,
                ]);
        }elseif($request->isPost){
            if ($model->load($request->post()) && $model->save(false)) {

                // clean old status of files
                Files::updateAll(['actual' => null],['group' => $group]);

                // find file
                $f = Files::find()->andWhere(['like','storedfilename',$model->l86_source])->one();
                if($f && $model->l86_source){
                    $f->group = $group;
                    $f->destination = 10;
                    //$f->current = 0;
                    $f->version = $model->l86_version;
                    $f->actual = ($f->actual===0) ? 2 : 1;
                    $f->save(false);
                }
                $f = Files::find()->andWhere(['like','storedfilename',$model->l64_source])->one();
                if($f && $model->l64_source){
                    $f->group = $group;
                    $f->destination = 11;
                    //$f->current = 0;
                    $f->version = $model->l64_version;
                    $f->actual = ($f->actual===0) ? 2 : 1;
                    $f->save(false);
                }
                $f = Files::find()->andWhere(['like','storedfilename',$model->b86_source])->one();
                if($f && $model->b86_source){
                    $f->group = $group;
                    $f->destination = 12;
                    $f->version = $model->b86_version;
                    //$f->current = 0;
                    $f->actual = ($f->actual===0) ? 2 : 1;
                    $f->save(false);
                }
                $f = Files::find()->andWhere(['like','storedfilename',$model->b64_source])->one();
                if($f && $model->b64_source){
                    $f->group = $group;
                    $f->destination = 13;
                    $f->version = $model->b64_version;
                    //$f->current = 0;
                    $f->actual = ($f->actual===0) ? 2 : 1;
                    $f->save(false);
                }

                $f = Files::find()->andWhere(['like','storedfilename',$model->sl86_source])->one();
                if($f && $model->sl86_source){
                    $f->group = $group;
                    $f->destination = 10;
                    //$f->current = 0;
                    $f->version = $model->l86_version;
                    $f->actual = ($f->actual==1) ? 2 : 0;
                    $f->save(false);
                }
                $f = Files::find()->andWhere(['like','storedfilename',$model->sl64_source])->one();
                if($f && $model->sl64_source){
                    $f->group = $group;
                    $f->destination = 11;
                    //$f->current = 0;
                    $f->version = $model->l64_version;
                    $f->actual = ($f->actual==1) ? 2 : 0;
                    $f->save(false);
                }
                $f = Files::find()->andWhere(['like','storedfilename',$model->sb86_source])->one();
                if($f && $model->sb86_source){
                    $f->group = $group;
                    $f->destination = 12;
                    $f->version = $model->b86_version;
                    //$f->current = 0;
                    $f->actual = ($f->actual==1) ? 2 : 0;
                    $f->save(false);
                }
                $f = Files::find()->andWhere(['like','storedfilename',$model->sb64_source])->one();
                if($f && $model->sb64_source){
                    $f->group = $group;
                    $f->destination = 13;
                    $f->version = $model->b64_version;
                    //$f->current = 0;
                    $f->actual = ($f->actual==1) ? 2 : 0;
                    $f->save(false);
                }
                
                return $this->redirect(Yii::$app->request->url);
            }
        }else{

            return $this->redirect(['index']);
        }
    }

    public function actionFiledelete($id)
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $request = Yii::$app->request;
        $f = Files::find()->where(['id'=>$id])->one()->delete();
        
        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            //return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
            return [
                    'title'=> "Update Groups #".$id,
                    'content'=>$this->renderAjax('update', [
                        //'model' => $model,
                    ]),
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"])
                ];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(Yii::$app->request->referrer);
        }


    }

    public function actionSetactual($id)
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $request = Yii::$app->request;
        $f = Files::find()->where(['id'=>$id])->one();
        $d = $f->destination;
        $g = $f->group;
        $f->actual = 1;
        $f->save(false);
        Files::updateAll(['actual' => null],['and',['and',['and',['group' => $g],['destination' => $d]],['<>','id',$id]],['actual'=>1]]);
        $group = Groups::findOne(['group'=>$g]);
        switch ($d) {
            case 10:
                $group->l86_created_at = $f->created_at;
                $group->l86_version = $f->version;
                $group->l86_source = $f->storedfilename;
                $group->l86_name = $f->filename;
                break;
            
            case 11:
                $group->l64_created_at = $f->created_at;
                $group->l64_version = $f->version;
                $group->l64_source = $f->storedfilename;
                $group->l64_name = $f->filename;
                break;
            
            case 12:
                $group->b86_created_at = $f->created_at;
                $group->b86_version = $f->version;
                $group->b86_source = $f->storedfilename;
                $group->b86_name = $f->filename;
                
                break;
            
            case 13:
                $group->b64_created_at = $f->created_at;
                $group->b64_version = $f->version;
                $group->b64_source = $f->storedfilename;
                $group->b64_name = $f->filename;
                
                break;
            
            default:
                # code...
                break;
        }
        $group->save(false);

        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
            return [
                    'title'=> "Update Groups #".$id,
                    'content'=>'ok',
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"])
                ];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(Yii::$app->request->referrer);
        }


    }

    public function actionSetstaged($id)
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $request = Yii::$app->request;
        $f = Files::find()->where(['id'=>$id])->one();
        $d = $f->destination;
        $g = $f->group;
        $f->actual = 0;
        $f->save(false);
        Files::updateAll(['actual' => null], ['and',  ['and',       ['and', ['group' => $g], ['destination' => $d] ], ['<>','id',$id]   ] , ['actual'=>0]  ]   );
        if($request->isAjax){
            /*
            *   Process for ajax request
            */
            Yii::$app->response->format = Response::FORMAT_JSON;
            return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];
            return [
                    'title'=> "Update Groups #".$id,
                    'content'=>'ok',
                    'footer'=> Html::button('Close',['class'=>'btn btn-default pull-left','data-dismiss'=>"modal"])
                ];
        }else{
            /*
            *   Process for non-ajax request
            */
            return $this->redirect(Yii::$app->request->referrer);
        }


    }

    /*public function actionSetfileactual($file)
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        $request = Yii::$app->request;
        if(isset($file)){
            $f = Files::find()->where(['storedfilename'=>$file])->one();
            $this->actionSetactual($f->id);
        }
    }*/

    
}
